/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.support.RoutePolicySupport;

public class FlipRoutePolicy
extends RoutePolicySupport {
    private final String name1;
    private final String name2;

    public FlipRoutePolicy(String name1, String name2) {
        this.name1 = name1;
        this.name2 = name2;
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        String stop = route.getId().equals(this.name1) ? this.name1 : this.name2;
        String start = route.getId().equals(this.name1) ? this.name2 : this.name1;
        FlipThread thread = new FlipThread(exchange.getContext(), start, stop);
        thread.start();
    }

    private final class FlipThread
    extends Thread {
        private final CamelContext context;
        private final String start;
        private final String stop;

        private FlipThread(CamelContext context, String start, String stop) {
            this.context = context;
            this.start = start;
            this.stop = stop;
        }

        @Override
        public void run() {
            try {
                this.context.stopRoute(this.stop);
                this.context.startRoute(this.start);
            }
            catch (Exception e) {
                FlipRoutePolicy.this.getExceptionHandler().handleException("Error flipping routes", (Throwable)e);
            }
        }
    }
}

