/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;

public class GenericXmlTokenizeTest
extends ContextTestSupport {
    public void testSendClosedTagMessageToTokenize() throws Exception {
        String message = "<?xml version='1.0' encoding='UTF-8' ?><parent><child anotherAttr='' some_attr=''></child></parent>";
        String expectedMessage = "<child anotherAttr=\"\" some_attr=\"\"/>";
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(new Object[]{expectedMessage});
        this.template.sendBody("direct:start", (Object)message);
        resultEndpoint.assertIsSatisfied();
    }

    public void testSendSelfClosingTagMessageToTokenize() throws Exception {
        String message = "<?xml version='1.0' encoding='UTF-8' ?><parent xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'><child some_attr='' anotherAttr='' /></parent>";
        String expectedMessage = "<child anotherAttr=\"\" some_attr=\"\"/>";
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(new Object[]{expectedMessage});
        this.template.sendBody("direct:start", (Object)message);
        resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().xpath("//child")).to("mock:result");
            }
        };
    }
}

