/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class MessageHistoryCopyExchangeTest
extends ContextTestSupport {
    public void testDefensiveCopyOfMessageHistory() throws Exception {
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List listA = (List)((Exchange)a.getReceivedExchanges().get(0)).getProperty("CamelMessageHistory");
        List listB = (List)((Exchange)b.getReceivedExchanges().get(0)).getProperty("CamelMessageHistory");
        MessageHistoryCopyExchangeTest.assertNotSame((Object)listA, (Object)listB);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MessageHistoryCopyExchangeTest.this.context.setMessageHistory(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:foo")).to("mock:a")).to("direct:bar")).to("mock:b");
                ((RouteDefinition)this.from("direct:bar").to("log:bar")).to("mock:bar");
            }
        };
    }
}

