/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;

public class MulticastFineGrainedErrorHandlingTest
extends ContextTestSupport {
    public void testMulticastOk() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).multicast().stopOnException().to(new String[]{"mock:foo", "mock:bar", "mock:baz"});
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testMulticastError() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).maximumRedeliveries(2);
                ((MulticastDefinition)((MulticastDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).multicast().stopOnException().to(new String[]{"mock:foo", "mock:bar"})).throwException((Exception)new IllegalArgumentException("Damn"))).to("mock:baz");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            MulticastFineGrainedErrorHandlingTest.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

