/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Animal;

public class MulticastNoOnPrepareTest
extends ContextTestSupport {
    public void testMulticastNoOnPrepare() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:a").message(0).body(String.class)).isEqualTo((Object)"1 Tony the Tiger");
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:b").message(0).body(String.class)).isEqualTo((Object)"1 Tony the Tiger");
        this.template.sendBody("direct:start", (Object)new Animal(1, "Tiger"));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:start").multicast().to("direct:a")).to("direct:b");
                ((RouteDefinition)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Animal body = (Animal)exchange.getIn().getBody(Animal.class);
                        TestCase.assertEquals((int)1, (int)body.getId());
                        TestCase.assertEquals((String)"Tiger", (String)body.getName());
                        body.setName("Tony the Tiger");
                    }
                })).to("mock:a");
                ((RouteDefinition)this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Animal body = (Animal)exchange.getIn().getBody(Animal.class);
                        TestCase.assertEquals((int)1, (int)body.getId());
                        TestCase.assertEquals((String)"Tony the Tiger", (String)body.getName());
                    }
                })).to("mock:b");
            }
        };
    }
}

