/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class NoErrorHandlerTest
extends ContextTestSupport {
    private static int counter;
    private static boolean jmx;

    @Override
    protected void setUp() throws Exception {
        counter = 0;
        if (jmx) {
            this.enableJMX();
            jmx = false;
        } else {
            this.disableJMX();
        }
        super.setUp();
    }

    public void testNoErrorHandler() throws Exception {
        this.doTest();
    }

    public void testNoErrorHandlerJMXDisabled() throws Exception {
        this.doTest();
    }

    private void doTest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Goodday World"});
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            NoErrorHandlerTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.template.sendBody("direct:start", (Object)"Bye World");
            NoErrorHandlerTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.template.sendBody("direct:start", (Object)"Goodday World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if (++counter < 3) {
                            throw new IllegalArgumentException("Forced by unit test");
                        }
                    }
                })).to("mock:result");
            }
        };
    }

    static {
        jmx = true;
    }
}

