/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;

public class OnCompletionMoreGlobalRouteCompletionTest
extends ContextTestSupport {
    public void testSynchronizeComplete() throws Exception {
        this.getMockEndpoint("mock:complete").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:failure").expectedMessageCount(0);
        this.getMockEndpoint("mock:two").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:sync").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSynchronizeFailure() throws Exception {
        this.getMockEndpoint("mock:complete").expectedMessageCount(0);
        this.getMockEndpoint("mock:failure").expectedMessageCount(1);
        this.getMockEndpoint("mock:two").expectedMessageCount(1);
        this.getMockEndpoint("mock:sync").expectedMessageCount(1);
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kabom");
            OnCompletionMoreGlobalRouteCompletionTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            OnCompletionMoreGlobalRouteCompletionTest.assertEquals((String)"Kabom", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testSynchronizeOtherComplete() throws Exception {
        this.getMockEndpoint("mock:complete").expectedMessageCount(0);
        this.getMockEndpoint("mock:failure").expectedMessageCount(0);
        this.getMockEndpoint("mock:two").expectedMessageCount(0);
        this.getMockEndpoint("mock:sync").expectedMessageCount(0);
        this.getMockEndpoint("mock:route").expectedBodiesReceived(new Object[]{"Bye World"});
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:other", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)this.onCompletion().to("log:global")).to("mock:sync");
                ((OnCompletionDefinition)this.onCompletion().to("log:global")).to("mock:two");
                ((OnCompletionDefinition)this.onCompletion().onCompleteOnly().to("log:global")).to("mock:complete");
                ((OnCompletionDefinition)this.onCompletion().onFailureOnly().to("log:global")).to("mock:failure");
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
                ((OnCompletionDefinition)this.from("direct:other").onCompletion().to("mock:route")).end().process((Processor)new MyProcessor()).to("mock:other");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if ("Kabom".equals(exchange.getIn().getBody())) {
                throw new IllegalArgumentException("Kabom");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

