/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;

public class RecipientListBeanTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        return jndi;
    }

    public void testRecipientListWithBean() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello c"});
        String out = (String)this.template.requestBody("direct:start", (Object)"direct:a,direct:b,direct:c", String.class);
        RecipientListBeanTest.assertEquals((String)"Hello c", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testRecipientListWithParams() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello b"});
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("one", 21);
        headers.put("two", "direct:a,direct:b,direct:c");
        String out = (String)this.template.requestBodyAndHeaders("direct:params", (Object)"Hello World", headers, String.class);
        RecipientListBeanTest.assertEquals((String)"Hello b", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").recipientList((Expression)this.method("myBean", "foo")).to("mock:result");
                this.from("direct:params").recipientList((Expression)this.method("myBean", "bar(${header.one}, ${header.two})"), ",").to("mock:result");
                this.from("direct:a").transform((Expression)this.constant("Hello a"));
                this.from("direct:b").transform((Expression)this.constant("Hello b"));
                this.from("direct:c").transform((Expression)this.constant("Hello c"));
            }
        };
    }

    public class MyBean {
        public String[] foo(String body) {
            return body.split(",");
        }

        public String bar(int one, String two) {
            TestCase.assertEquals((int)21, (int)one);
            TestCase.assertEquals((String)"direct:a,direct:b,direct:c", (String)two);
            return "direct:c,direct:b";
        }
    }
}

