/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class RedeliveryWithExceptionAndFaultDelayInHeader
extends ContextTestSupport {
    private static int counter;

    public void testOk() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        RedeliveryWithExceptionAndFaultDelayInHeader.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testTransientAndPersistentError() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        String out = (String)this.template.requestBody("direct:start", (Object)"Boom", String.class);
        RedeliveryWithExceptionAndFaultDelayInHeader.assertEquals((String)"Persistent error", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testTransientAndPersistentErrorWithExchange() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Boom");
            }
        });
        RedeliveryWithExceptionAndFaultDelayInHeader.assertTrue((String)"Should be failed", (boolean)out.isFailed());
        RedeliveryWithExceptionAndFaultDelayInHeader.assertNull((String)"No exception", (Object)out.getException());
        RedeliveryWithExceptionAndFaultDelayInHeader.assertTrue((out.getOut() != null && out.getOut().isFault() ? 1 : 0) != 0);
        RedeliveryWithExceptionAndFaultDelayInHeader.assertEquals((Object)"Persistent error", (Object)out.getOut().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(5));
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setHeader("CamelRedeliveryDelay", (Object)100);
                        counter++;
                        if (counter < 3) {
                            throw new IllegalArgumentException("Try again");
                        }
                        if (exchange.getIn().getBody().equals("Boom")) {
                            exchange.getOut().setFault(true);
                            exchange.getOut().setBody((Object)"Persistent error");
                        } else {
                            exchange.getOut().setBody((Object)"Bye World");
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

