/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class RollbackTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(0);
        this.template.requestBody("direct:start", (Object)"ok");
        this.assertMockEndpointsSatisfied();
    }

    public void testRollback() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(1);
        try {
            this.template.requestBody("direct:start", (Object)"bad");
            RollbackTest.fail((String)"Should have thrown a RollbackExchangeException");
        }
        catch (RuntimeCamelException e) {
            RollbackTest.assertTrue((boolean)(e.getCause() instanceof RollbackExchangeException));
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testRollbackWithExchange() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:rollback").expectedMessageCount(1);
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"bad");
            }
        });
        this.assertMockEndpointsSatisfied();
        RollbackTest.assertNotNull((Object)out.getException());
        RollbackTest.assertIsInstanceOf(RollbackExchangeException.class, out.getException());
        RollbackTest.assertEquals((String)"Should be marked as rollback", (boolean)true, (boolean)out.isRollbackOnly());
        RollbackTest.assertEquals((Object)0, (Object)out.getIn().getHeader("CamelRedeliveryCounter"));
        RollbackTest.assertEquals((Object)false, (Object)out.getIn().getHeader("CamelRedelivered"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().isNotEqualTo((Object)"ok")).to("mock:rollback")).rollback("That do not work")).otherwise().to("mock:result")).end();
            }
        };
    }
}

