/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class RoutePerformanceCountTest
extends ContextTestSupport {
    private CountProcessor processor = new CountProcessor();
    private int size = 500;
    private String url = "direct:start";

    public void testSendMessages() throws Exception {
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.size; ++i) {
            this.template.sendBody(this.url, (Object)("Message " + i));
        }
        RoutePerformanceCountTest.assertEquals((int)this.size, (int)this.processor.getCounter());
        long delta = System.currentTimeMillis() - start;
        this.log.info("RoutePerformanceCountTest: Sent: " + this.size + " Took: " + delta + " ms");
    }

    @Override
    protected boolean canRunOnThisPlatform() {
        String os = System.getProperty("os.name");
        return !os.toLowerCase(Locale.ENGLISH).contains("hp-ux");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to(new String[]{"log:a?level=OFF", "log:b?level=OFF", "direct:c"});
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:c").choice().when().header("foo")).process((Processor)RoutePerformanceCountTest.this.processor)).otherwise().process((Processor)RoutePerformanceCountTest.this.processor)).end();
            }
        };
    }

    private static class CountProcessor
    implements Processor {
        private AtomicInteger counter = new AtomicInteger(0);

        private CountProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            this.counter.incrementAndGet();
        }

        public int getCounter() {
            return this.counter.intValue();
        }
    }
}

