/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class SetExchangePatternTest
extends ContextTestSupport {
    public void testInOut() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testInOut", ExchangePattern.InOut);
    }

    public void testInOnly() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testInOnly", ExchangePattern.InOnly);
    }

    public void testSetToInOnlyThenTo() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testSetToInOnlyThenTo", ExchangePattern.InOnly);
    }

    public void testSetToInOutThenTo() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testSetToInOutThenTo", ExchangePattern.InOut);
    }

    public void testToWithInOnlyParam() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testToWithInOnlyParam", ExchangePattern.InOnly);
    }

    public void testToWithInOutParam() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testToWithInOutParam", ExchangePattern.InOut);
    }

    public void testToWithRobustInOnlyParam() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testToWithRobustInOnlyParam", ExchangePattern.RobustInOnly);
    }

    public void testSetExchangePatternInOnly() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testSetExchangePatternInOnly", ExchangePattern.InOnly);
    }

    public void testPreserveOldMEPInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOut);
        Exchange out = this.template.send("direct:testInOut", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.setPattern(ExchangePattern.InOnly);
            }
        });
        SetExchangePatternTest.assertNotNull((Object)out);
        SetExchangePatternTest.assertEquals((Object)ExchangePattern.InOnly, (Object)out.getPattern());
        this.assertMockEndpointsSatisfied();
    }

    public void testPreserveOldMEPInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        Exchange out = this.template.send("direct:testInOnly", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.setPattern(ExchangePattern.InOut);
            }
        });
        SetExchangePatternTest.assertNotNull((Object)out);
        SetExchangePatternTest.assertEquals((Object)ExchangePattern.InOut, (Object)out.getPattern());
        this.assertMockEndpointsSatisfied();
    }

    protected void assertMessageReceivedWithPattern(String sendUri, ExchangePattern expectedPattern) throws InterruptedException {
        ExchangePattern sendPattern;
        switch (expectedPattern) {
            case InOut: {
                sendPattern = ExchangePattern.InOnly;
                break;
            }
            case InOnly: 
            case RobustInOnly: {
                sendPattern = ExchangePattern.InOut;
                break;
            }
            default: {
                sendPattern = ExchangePattern.InOnly;
            }
        }
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        String expectedBody = "InOnlyMessage";
        resultEndpoint.expectedBodiesReceived(new Object[]{expectedBody});
        resultEndpoint.expectedHeaderReceived("foo", (Object)"bar");
        this.template.sendBodyAndHeader(sendUri, sendPattern, (Object)expectedBody, "foo", (Object)"bar");
        resultEndpoint.assertIsSatisfied();
        ExchangePattern actualPattern = ((Exchange)resultEndpoint.getExchanges().get(0)).getPattern();
        SetExchangePatternTest.assertEquals((String)"received exchange pattern", (Object)actualPattern, (Object)expectedPattern);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:testInOut").inOut("mock:result");
                this.from("direct:testInOnly").inOnly("mock:result");
                ((RouteDefinition)this.from("direct:testSetToInOnlyThenTo").setExchangePattern(ExchangePattern.InOnly)).to("mock:result");
                ((RouteDefinition)this.from("direct:testSetToInOutThenTo").setExchangePattern(ExchangePattern.InOut)).to("mock:result");
                this.from("direct:testToWithInOnlyParam").to(ExchangePattern.InOnly, "mock:result");
                this.from("direct:testToWithInOutParam").to(ExchangePattern.InOut, "mock:result");
                this.from("direct:testToWithRobustInOnlyParam").to(ExchangePattern.RobustInOnly, "mock:result");
                ((RouteDefinition)this.from("direct:testSetExchangePatternInOnly").setExchangePattern(ExchangePattern.InOnly)).to("mock:result");
            }
        };
    }
}

