/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;

public class SplitTokenizerNamespaceTest
extends ContextTestSupport {
    public void testSplitTokenizerWithImplicitNamespaces() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"<ns1:person xmlns:ns1=\"urn:org.apache.camel\" xmlns:ns2=\"urn:org.apache.cameltoo\">Claus</ns1:person>", "<ns1:person xmlns:ns1=\"urn:org.apache.camel\" xmlns:ns2=\"urn:org.apache.cameltoo\">James</ns1:person>", "<ns1:person xmlns:ns1=\"urn:org.apache.camel\" xmlns:ns2=\"urn:org.apache.cameltoo\">Willem</ns1:person>", "<ns2:person xmlns:ns1=\"urn:org.apache.camel\" xmlns:ns2=\"urn:org.apache.cameltoo\">Rich</ns2:person>"});
        this.template.sendBody("direct:noPrefix", (Object)this.getXmlBody());
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitTokenizerWithExplicitNamespaces() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"<ns1:person xmlns:ns1=\"urn:org.apache.camel\" xmlns:ns2=\"urn:org.apache.cameltoo\">Claus</ns1:person>", "<ns1:person xmlns:ns1=\"urn:org.apache.camel\" xmlns:ns2=\"urn:org.apache.cameltoo\">James</ns1:person>", "<ns1:person xmlns:ns1=\"urn:org.apache.camel\" xmlns:ns2=\"urn:org.apache.cameltoo\">Willem</ns1:person>"});
        this.template.sendBody("direct:explicitPrefix", (Object)this.getXmlBody());
        this.assertMockEndpointsSatisfied();
    }

    protected String getXmlBody() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n");
        sb.append("<ns1:persons xmlns:ns1=\"urn:org.apache.camel\" xmlns:ns2=\"urn:org.apache.cameltoo\">\n");
        sb.append("  <ns1:person>Claus</ns1:person>\n");
        sb.append("  <ns1:person>James</ns1:person>\n");
        sb.append("  <ns1:person>Willem</ns1:person>\n");
        sb.append("  <ns2:person>Rich</ns2:person>\n");
        sb.append("</ns1:persons>");
        return sb.toString();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((SplitDefinition)this.from("direct:noPrefix").split().tokenizeXML("person", "persons")).to("mock:split");
                ((SplitDefinition)this.from("direct:explicitPrefix").split().tokenizeXML("ns1:person", "ns1:persons")).to("mock:split");
            }
        };
    }
}

