/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.Future;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.StopWatch;

public class SplitterParallelAggregateTest
extends ContextTestSupport {
    private boolean enabled;

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:splitSynchronizedAggregation").split((Expression)this.method(new MySplitter(), "rowIterator"), (AggregationStrategy)new MyAggregationStrategy()).to("log:someSplitProcessing?groupSize=500");
                this.from("direct:splitUnsynchronizedAggregation").split((Expression)this.method(new MySplitter(), "rowIterator"), (AggregationStrategy)new MyAggregationStrategy()).parallelAggregate().to("log:someSplitProcessing?groupSize=500");
            }
        };
    }

    public void test1() throws Exception {
        if (!this.enabled) {
            return;
        }
        int numberOfRequests = 1;
        this.timeSplitRoutes(numberOfRequests);
    }

    public void test2() throws Exception {
        if (!this.enabled) {
            return;
        }
        int numberOfRequests = 2;
        this.timeSplitRoutes(numberOfRequests);
    }

    public void test4() throws Exception {
        if (!this.enabled) {
            return;
        }
        int numberOfRequests = 4;
        this.timeSplitRoutes(numberOfRequests);
    }

    protected void timeSplitRoutes(int numberOfRequests) throws Exception {
        String[] endpoints = new String[]{"direct:splitSynchronizedAggregation", "direct:splitUnsynchronizedAggregation"};
        ArrayList<Future> futures = new ArrayList<Future>();
        StopWatch stopWatch = new StopWatch(false);
        for (String endpoint : endpoints) {
            stopWatch.restart();
            for (int requestIndex = 0; requestIndex < numberOfRequests; ++requestIndex) {
                futures.add(this.template.asyncRequestBody(endpoint, null, File.class));
            }
            for (int i = 0; i < futures.size(); ++i) {
                Future future = (Future)futures.get(i);
                future.get();
            }
            stopWatch.stop();
            this.log.info(String.format("test%d.%s=%d\n", numberOfRequests, endpoint, stopWatch.taken()));
        }
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            Random random = new Random(System.currentTimeMillis());
            for (int i = 0; i < 10000; ++i) {
                random.nextGaussian();
            }
            return newExchange;
        }
    }

    public static class MySplitter {
        public Iterator<String[]> rowIterator() {
            LinkedList<String[]> rows = new LinkedList<String[]>();
            for (int i = 0; i < 10000; ++i) {
                String[] row = new String[10];
                for (int j = 0; j < row.length; ++j) {
                    row[j] = String.valueOf(System.nanoTime());
                }
                rows.add(row);
            }
            return rows.iterator();
        }
    }
}

