/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;

public class SplitterWithCustomThreadPoolExecutorTest
extends ContextTestSupport {
    protected ThreadPoolExecutor customThreadPoolExecutor = new ThreadPoolExecutor(8, 16, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public void testSplitterWithCustomThreadPoolExecutor() throws Exception {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.getSplitter().getExecutorService();
        if (threadPoolExecutor == null) {
            threadPoolExecutor = (ThreadPoolExecutor)this.context.getRegistry().lookupByNameAndType(this.getSplitter().getExecutorServiceRef(), ThreadPoolExecutor.class);
        }
        SplitterWithCustomThreadPoolExecutorTest.assertTrue((threadPoolExecutor.getCorePoolSize() == this.getThreadPoolExecutor().getCorePoolSize() ? 1 : 0) != 0);
        SplitterWithCustomThreadPoolExecutorTest.assertTrue((threadPoolExecutor.getMaximumPoolSize() == this.getThreadPoolExecutor().getMaximumPoolSize() ? 1 : 0) != 0);
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this.customThreadPoolExecutor;
    }

    protected SplitDefinition getSplitter() {
        RouteDefinition routeType;
        SplitDefinition result = null;
        List routeDefinitions = this.context.getRouteDefinitions();
        Iterator i$ = routeDefinitions.iterator();
        while (i$.hasNext() && (result = this.firstSplitterType((routeType = (RouteDefinition)i$.next()).getOutputs())) == null) {
        }
        return result;
    }

    protected SplitDefinition firstSplitterType(List<ProcessorDefinition<?>> outputs) {
        ProcessorDefinition<?> processorType;
        SplitDefinition result = null;
        Iterator<ProcessorDefinition<?>> i$ = outputs.iterator();
        while (i$.hasNext() && (result = (processorType = i$.next()) instanceof SplitDefinition ? (SplitDefinition)processorType : this.firstSplitterType(processorType.getOutputs())) == null) {
        }
        return result;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:parallel-custom-pool").split((Expression)this.body().tokenize(",")).parallelProcessing().executorService((ExecutorService)SplitterWithCustomThreadPoolExecutorTest.this.customThreadPoolExecutor).to("mock:result");
            }
        };
    }
}

