/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.ThreadPoolProfile;

public class ThreadsInvalidConfigTest
extends ContextTestSupport {
    ThreadPoolProfile threadPoolProfile = new ThreadPoolProfile("poll");

    public void testCreateRouteIfNoInvalidOptions() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                this.from("direct:start").threads().executorServiceRef(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).to("mock:test");
            }
        });
    }

    public void testFailIfThreadNameAndExecutorServiceRef() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorServiceRef(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).threadName("foo").to("mock:test");
                }
            });
        }
        catch (FailedToCreateRouteException e) {
            ThreadsInvalidConfigTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            ThreadsInvalidConfigTest.assertTrue((boolean)e.getCause().getMessage().startsWith("ThreadName"));
            return;
        }
        ThreadsInvalidConfigTest.fail();
    }

    public void testPassIfThreadNameWithoutExecutorServiceRef() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                this.from("direct:start").threads().threadName("foo").to("mock:test");
            }
        });
    }

    public void testFailIfPoolSizeAndExecutorServiceRef() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorServiceRef(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).poolSize(1).to("mock:test");
                }
            });
        }
        catch (FailedToCreateRouteException e) {
            ThreadsInvalidConfigTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            ThreadsInvalidConfigTest.assertTrue((boolean)e.getCause().getMessage().startsWith("PoolSize"));
            return;
        }
        ThreadsInvalidConfigTest.fail();
    }

    public void testFailIfMaxPoolSizeAndExecutorServiceRef() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorServiceRef(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).maxPoolSize(1).to("mock:test");
                }
            });
        }
        catch (FailedToCreateRouteException e) {
            ThreadsInvalidConfigTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            ThreadsInvalidConfigTest.assertTrue((boolean)e.getCause().getMessage().startsWith("MaxPoolSize"));
            return;
        }
        ThreadsInvalidConfigTest.fail();
    }

    public void testFailIfKeepAliveTimeAndExecutorServiceRef() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorServiceRef(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).keepAliveTime(1L).to("mock:test");
                }
            });
        }
        catch (FailedToCreateRouteException e) {
            ThreadsInvalidConfigTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            ThreadsInvalidConfigTest.assertTrue((boolean)e.getCause().getMessage().startsWith("KeepAliveTime"));
            return;
        }
        ThreadsInvalidConfigTest.fail();
    }

    public void testFailIfMaxQueueSizeAndExecutorServiceRef() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorServiceRef(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).maxQueueSize(1).to("mock:test");
                }
            });
        }
        catch (FailedToCreateRouteException e) {
            ThreadsInvalidConfigTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            ThreadsInvalidConfigTest.assertTrue((boolean)e.getCause().getMessage().startsWith("MaxQueueSize"));
            return;
        }
        ThreadsInvalidConfigTest.fail();
    }

    public void testFailIfRejectedPolicyAndExecutorServiceRef() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ThreadsInvalidConfigTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(ThreadsInvalidConfigTest.this.threadPoolProfile);
                    this.from("direct:start").threads().executorServiceRef(ThreadsInvalidConfigTest.this.threadPoolProfile.getId()).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).to("mock:test");
                }
            });
        }
        catch (FailedToCreateRouteException e) {
            ThreadsInvalidConfigTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            ThreadsInvalidConfigTest.assertTrue((boolean)e.getCause().getMessage().startsWith("RejectedPolicy"));
            return;
        }
        ThreadsInvalidConfigTest.fail();
    }
}

