/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class ThreadsRejectedExecutionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testThreadsRejectedExecution() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").to("log:before")).threads().executorService((ExecutorService)pool).delay(1000L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedMessageCount(3);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Hi World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testThreadsRejectedExecutionCallerNotRuns() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").to("log:before")).threads().executorService((ExecutorService)pool).callerRunsWhenRejected(false).delay(1000L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.setResultWaitTime(5000L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.template.sendBody("seda:start", (Object)"Hi World");
        this.template.sendBody("seda:start", (Object)"Bye World");
        mock.assertIsNotSatisfied();
        ThreadsRejectedExecutionTest.assertEquals((int)1, (int)mock.getReceivedCounter());
    }

    public void testThreadsRejectedDiscard() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").to("log:before")).threads(1, 1).maxPoolSize(1).maxQueueSize(2).rejectedPolicy(ThreadPoolRejectedPolicy.Discard).delay(1000L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(10).create();
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(2);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        ThreadsRejectedExecutionTest.assertTrue((boolean)notify.matchesMockWaitTime());
        int inflight = this.context.getInflightRepository().size();
        ThreadsRejectedExecutionTest.assertEquals((int)0, (int)inflight);
    }

    public void testThreadsRejectedDiscardOldest() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").to("log:before")).threads(1, 1).maxPoolSize(1).maxQueueSize(2).rejectedPolicy(ThreadPoolRejectedPolicy.DiscardOldest).delay(1000L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(10).create();
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(2);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        ThreadsRejectedExecutionTest.assertTrue((boolean)notify.matchesMockWaitTime());
        int inflight = this.context.getInflightRepository().size();
        ThreadsRejectedExecutionTest.assertEquals((int)0, (int)inflight);
    }

    public void testThreadsRejectedAbort() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").to("log:before")).threads(1, 1).maxPoolSize(1).maxQueueSize(2).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).delay(1000L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(10).create();
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(2);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        ThreadsRejectedExecutionTest.assertTrue((boolean)notify.matchesMockWaitTime());
        int inflight = this.context.getInflightRepository().size();
        ThreadsRejectedExecutionTest.assertEquals((int)0, (int)inflight);
    }

    public void testThreadsRejectedCallerRuns() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").to("log:before")).threads(1, 1).maxPoolSize(1).maxQueueSize(2).rejectedPolicy(ThreadPoolRejectedPolicy.CallerRuns).delay(200L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(10).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(10);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        ThreadsRejectedExecutionTest.assertTrue((boolean)notify.matchesMockWaitTime());
        int inflight = this.context.getInflightRepository().size();
        ThreadsRejectedExecutionTest.assertEquals((int)0, (int)inflight);
    }

    public void testThreadsRejectedAbortNoRedelivery() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).maximumRedeliveries(3).handled(true).to("mock:error");
                ((ExpressionNode)((RouteDefinition)this.from("seda:start").to("log:before")).threads(1, 1).maxPoolSize(1).maxQueueSize(2).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).delay(1000L).to("log:after")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(10).create();
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(2);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        ThreadsRejectedExecutionTest.assertTrue((boolean)notify.matchesMockWaitTime());
        int inflight = this.context.getInflightRepository().size();
        ThreadsRejectedExecutionTest.assertEquals((int)0, (int)inflight);
    }
}

