/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.RouteBuilder;

public class ThreadsRejectedPolicyTest
extends ContextTestSupport {
    public void testThreadsRejectedPolicy() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testThreadsRejectedPolicyBuilder() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").threads(5, 10).rejectedPolicy(ThreadPoolRejectedPolicy.DiscardOldest).to("mock:result");
                this.from("direct:foo").threads().poolSize(5).maxPoolSize(10).rejectedPolicy(ThreadPoolRejectedPolicy.DiscardOldest).threadName("myPool").to("mock:result");
            }
        };
    }
}

