/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class TopicLoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().topic().to(new String[]{"mock:x", "mock:y", "mock:z"});
            }
        };
    }

    public void testTopicManyMessages() throws Exception {
        this.x.expectedMessageCount(10);
        this.y.expectedMessageCount(10);
        this.z.expectedMessageCount(10);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)"Hello World");
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testTopic() throws Exception {
        this.x.expectedBodiesReceived(new Object[]{"Hello World"});
        this.y.expectedBodiesReceived(new Object[]{"Hello World"});
        this.z.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

