/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class TracePerRouteTest
extends ContextTestSupport {
    public void testTracingPerRoute() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        MockEndpoint traced = this.getMockEndpoint("mock:traced");
        traced.expectedMessageCount(2);
        ((ValueBuilder)traced.message(0).body(String.class)).contains((Object)"mock://a");
        ((ValueBuilder)traced.message(1).body(String.class)).contains((Object)"mock://c");
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.sendBody("direct:b", (Object)"Bye World");
        this.template.sendBody("direct:c", (Object)"Gooday World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                tracer.setDestinationUri("mock:traced");
                tracer.setLogName("foo");
                TracePerRouteTest.this.context.addInterceptStrategy((InterceptStrategy)tracer);
                this.from("direct:a").to("mock:a");
                this.from("direct:b").noTracing().to("mock:b");
                this.from("direct:c").tracing().to("mock:c");
            }
        };
    }
}

