/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.w3c.dom.NodeList;

public class TransformXpathTest
extends ContextTestSupport {
    public void testTransformWithXpath() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isInstanceOf(NodeList.class);
        String xml = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("src/test/resources/org/apache/camel/processor/students.xml"));
        this.template.sendBody("direct:start", (Object)xml);
        this.assertMockEndpointsSatisfied();
        NodeList list = (NodeList)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(NodeList.class);
        TransformXpathTest.assertEquals((int)2, (int)list.getLength());
        TransformXpathTest.assertEquals((String)"Claus", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)list.item(0).getTextContent().trim())));
        TransformXpathTest.assertEquals((String)"Hadrian", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)list.item(1).getTextContent().trim())));
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").transform().xpath("//students/student")).to("mock:result");
            }
        };
    }
}

