/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class WireTapCustomPool2Test
extends ContextTestSupport {
    protected MockEndpoint tap;
    protected MockEndpoint result;
    protected ExecutorService pool;

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.pool != null) {
            this.pool.shutdownNow();
        }
    }

    public void testSend() throws Exception {
        this.result.expectedBodiesReceived(new Object[]{"Hello World", "Tapped"});
        this.tap.expectedBodiesReceived(new Object[]{"Tapped"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.tap = this.getMockEndpoint("mock:tap");
        this.result = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                WireTapCustomPool2Test.this.pool = Executors.newFixedThreadPool(2);
                ((RouteDefinition)this.from("direct:start").to("log:foo")).wireTap("direct:tap").executorService(WireTapCustomPool2Test.this.pool).to("mock:result");
                ((ProcessorDefinition)this.from("direct:tap").delay(1000L).setBody().constant((Object)"Tapped")).to(new String[]{"mock:result", "mock:tap"});
            }
        };
    }
}

