/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class WireTapNewExchangeTest
extends ContextTestSupport {
    public void testFireAndForgetUsingExpressions() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint tap = this.getMockEndpoint("mock:tap");
        tap.expectedBodiesReceived(new Object[]{"Bye World"});
        tap.expectedHeaderReceived("id", (Object)123);
        String today = new SimpleDateFormat("yyyyMMdd").format(new Date());
        tap.expectedHeaderReceived("date", (Object)today);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").wireTap("direct:tap").newExchangeBody((Expression)this.constant("Bye World")).newExchangeHeader("id", (Expression)this.constant(123)).newExchangeHeader("date", (Expression)this.simple("${date:now:yyyyMMdd}")).end()).to("mock:result");
                this.from("direct:tap").to("mock:tap");
            }
        };
    }
}

