/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class AggregateGroupedExchangeMultipleCorrelationTest
extends ContextTestSupport {
    public void testGrouped() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"100", "foo", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"130", "foo", (Object)"B");
        this.template.sendBodyAndHeader("direct:start", (Object)"150", "foo", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"200", "foo", (Object)"B");
        this.template.sendBodyAndHeader("direct:start", (Object)"180", "foo", (Object)"B");
        Thread.sleep(250L);
        this.template.sendBodyAndHeader("direct:start", (Object)"120", "foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)result.getExchanges().get(0);
        List grouped = (List)out.getIn().getBody(List.class);
        AggregateGroupedExchangeMultipleCorrelationTest.assertEquals((int)3, (int)grouped.size());
        AggregateGroupedExchangeMultipleCorrelationTest.assertEquals((String)"130", (String)((String)((Exchange)grouped.get(0)).getIn().getBody(String.class)));
        AggregateGroupedExchangeMultipleCorrelationTest.assertEquals((String)"200", (String)((String)((Exchange)grouped.get(1)).getIn().getBody(String.class)));
        AggregateGroupedExchangeMultipleCorrelationTest.assertEquals((String)"180", (String)((String)((Exchange)grouped.get(2)).getIn().getBody(String.class)));
        out = (Exchange)result.getExchanges().get(1);
        grouped = (List)out.getIn().getBody(List.class);
        AggregateGroupedExchangeMultipleCorrelationTest.assertEquals((int)3, (int)grouped.size());
        AggregateGroupedExchangeMultipleCorrelationTest.assertEquals((String)"100", (String)((String)((Exchange)grouped.get(0)).getIn().getBody(String.class)));
        AggregateGroupedExchangeMultipleCorrelationTest.assertEquals((String)"150", (String)((String)((Exchange)grouped.get(1)).getIn().getBody(String.class)));
        AggregateGroupedExchangeMultipleCorrelationTest.assertEquals((String)"120", (String)((String)((Exchange)grouped.get(2)).getIn().getBody(String.class)));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("foo")).groupExchanges().completionTimeout(1000L).to("mock:result");
            }
        };
    }
}

