/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.ExceptionHandler;

public class AggregateProcessorTest
extends ContextTestSupport {
    private ExecutorService executorService;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void testAggregateProcessorCompletionPredicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+B+END"});
        mock.expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"predicate");
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        Predicate complete = AggregateProcessorTest.body().contains((Object)"END");
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionPredicate(complete);
        ap.setEagerCheckCompletion(false);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)123);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"END");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"D");
        e4.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateProcessorCompletionPredicateEager() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+B+END"});
        mock.expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"predicate");
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        Predicate complete = AggregateProcessorTest.body().isEqualTo((Object)"END");
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionPredicate(complete);
        ap.setEagerCheckCompletion(true);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)123);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"END");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"D");
        e4.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateProcessorCompletionAggregatedSize() throws Exception {
        this.doTestAggregateProcessorCompletionAggregatedSize(false);
    }

    public void testAggregateProcessorCompletionAggregatedSizeEager() throws Exception {
        this.doTestAggregateProcessorCompletionAggregatedSize(true);
    }

    private void doTestAggregateProcessorCompletionAggregatedSize(boolean eager) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+B+C"});
        mock.expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"size");
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionSize(3);
        ap.setEagerCheckCompletion(eager);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)123);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"C");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"D");
        e4.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateProcessorCompletionTimeout() throws Exception {
        this.doTestAggregateProcessorCompletionTimeout(false);
    }

    public void testAggregateProcessorCompletionTimeoutEager() throws Exception {
        this.doTestAggregateProcessorCompletionTimeout(true);
    }

    private void doTestAggregateProcessorCompletionTimeout(boolean eager) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+B+C"});
        mock.expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"timeout");
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionTimeout(3000L);
        ap.setEagerCheckCompletion(eager);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)123);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"C");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"D");
        e4.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        Thread.sleep(250L);
        ap.process((Exchange)e2);
        Thread.sleep(500L);
        ap.process((Exchange)e3);
        Thread.sleep(5000L);
        ap.process((Exchange)e4);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateCompletionInterval() throws Exception {
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+B+C", "D"});
        mock.expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"interval");
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionInterval(3000L);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)123);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"C");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"D");
        e4.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        Thread.sleep(5000L);
        ap.process((Exchange)e4);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateIgnoreInvalidCorrelationKey() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+C+END"});
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        Predicate complete = AggregateProcessorTest.body().contains((Object)"END");
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionPredicate(complete);
        ap.setIgnoreInvalidCorrelationKeys(true);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"C");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"END");
        e4.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateBadCorrelationKey() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+C+END"});
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        Predicate complete = AggregateProcessorTest.body().contains((Object)"END");
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionPredicate(complete);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"C");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"END");
        e4.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        Exception e = e2.getException();
        AggregateProcessorTest.assertNotNull((Object)e);
        AggregateProcessorTest.assertEquals((String)"Invalid correlation key. Exchange[Message: B]", (String)e.getMessage());
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateCloseCorrelationKeyOnCompletion() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+B+END"});
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        Predicate complete = AggregateProcessorTest.body().contains((Object)"END");
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionPredicate(complete);
        ap.setCloseCorrelationKeyOnCompletion(Integer.valueOf(1000));
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)123);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"END");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"C");
        e4.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        Exception e = e4.getException();
        AggregateProcessorTest.assertNotNull((Object)e);
        AggregateProcessorTest.assertEquals((String)"The correlation key [123] has been closed. Exchange[Message: C]", (String)e.getMessage());
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateUseBatchSizeFromConsumer() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+B", "C+D+E"});
        mock.expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"consumer");
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionSize(100);
        ap.setCompletionFromBatchConsumer(true);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        e1.setProperty("CamelBatchIndex", (Object)0);
        e1.setProperty("CamelBatchSize", (Object)2);
        e1.setProperty("CamelBatchComplete", (Object)false);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)123);
        e2.setProperty("CamelBatchIndex", (Object)1);
        e2.setProperty("CamelBatchSize", (Object)2);
        e2.setProperty("CamelBatchComplete", (Object)true);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"C");
        e3.getIn().setHeader("id", (Object)123);
        e3.setProperty("CamelBatchIndex", (Object)0);
        e3.setProperty("CamelBatchSize", (Object)3);
        e3.setProperty("CamelBatchComplete", (Object)false);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"D");
        e4.getIn().setHeader("id", (Object)123);
        e4.setProperty("CamelBatchIndex", (Object)1);
        e4.setProperty("CamelBatchSize", (Object)3);
        e4.setProperty("CamelBatchComplete", (Object)false);
        DefaultExchange e5 = new DefaultExchange((CamelContext)this.context);
        e5.getIn().setBody((Object)"E");
        e5.getIn().setHeader("id", (Object)123);
        e5.setProperty("CamelBatchIndex", (Object)2);
        e5.setProperty("CamelBatchSize", (Object)3);
        e5.setProperty("CamelBatchComplete", (Object)true);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        ap.process((Exchange)e5);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateLogFailedExchange() throws Exception {
        this.doTestAggregateLogFailedExchange(null);
    }

    public void testAggregateHandleFailedExchange() throws Exception {
        final AtomicBoolean tested = new AtomicBoolean();
        ExceptionHandler myHandler = new ExceptionHandler(){

            public void handleException(Throwable exception) {
            }

            public void handleException(String message, Throwable exception) {
            }

            public void handleException(String message, Exchange exchange, Throwable exception) {
                TestCase.assertEquals((String)"Error processing aggregated exchange", (String)message);
                TestCase.assertEquals((Object)"B+Kaboom+END", (Object)exchange.getIn().getBody());
                TestCase.assertEquals((String)"Damn", (String)exception.getMessage());
                tested.set(true);
            }
        };
        this.doTestAggregateLogFailedExchange(myHandler);
        AggregateProcessorTest.assertEquals((boolean)true, (boolean)tested.get());
    }

    private void doTestAggregateLogFailedExchange(ExceptionHandler handler) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A+END"});
        Processor done = new Processor(){

            public void process(Exchange exchange) throws Exception {
                if (((String)exchange.getIn().getBody(String.class)).contains("Kaboom")) {
                    throw new IllegalArgumentException("Damn");
                }
                SendProcessor send = new SendProcessor(AggregateProcessorTest.this.context.getEndpoint("mock:result"));
                send.start();
                send.process(exchange);
            }
        };
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setEagerCheckCompletion(true);
        ap.setCompletionPredicate(AggregateProcessorTest.body().isEqualTo((Object)"END"));
        if (handler != null) {
            ap.setExceptionHandler(handler);
        }
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)456);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"Kaboom");
        e3.getIn().setHeader("id", (Object)456);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"END");
        e4.getIn().setHeader("id", (Object)456);
        DefaultExchange e5 = new DefaultExchange((CamelContext)this.context);
        e5.getIn().setBody((Object)"END");
        e5.getIn().setHeader("id", (Object)123);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        ap.process((Exchange)e5);
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }

    public void testAggregateForceCompletion() throws Exception {
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"B+END", "A+END"});
        mock.expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"forceCompletion");
        SendProcessor done = new SendProcessor(this.context.getEndpoint("mock:result"));
        ValueBuilder corr = AggregateProcessorTest.header("id");
        BodyInAggregatingStrategy as = new BodyInAggregatingStrategy();
        AggregateProcessor ap = new AggregateProcessor((CamelContext)this.context, (Processor)done, (Expression)corr, (AggregationStrategy)as, this.executorService, true);
        ap.setCompletionSize(10);
        ap.start();
        DefaultExchange e1 = new DefaultExchange((CamelContext)this.context);
        e1.getIn().setBody((Object)"A");
        e1.getIn().setHeader("id", (Object)123);
        DefaultExchange e2 = new DefaultExchange((CamelContext)this.context);
        e2.getIn().setBody((Object)"B");
        e2.getIn().setHeader("id", (Object)456);
        DefaultExchange e3 = new DefaultExchange((CamelContext)this.context);
        e3.getIn().setBody((Object)"END");
        e3.getIn().setHeader("id", (Object)123);
        DefaultExchange e4 = new DefaultExchange((CamelContext)this.context);
        e4.getIn().setBody((Object)"END");
        e4.getIn().setHeader("id", (Object)456);
        ap.process((Exchange)e1);
        ap.process((Exchange)e2);
        ap.process((Exchange)e3);
        ap.process((Exchange)e4);
        AggregateProcessorTest.assertEquals((String)"should not have completed yet", (int)0, (int)mock.getExchanges().size());
        ap.forceCompletionOfAllGroups();
        this.assertMockEndpointsSatisfied();
        ap.stop();
    }
}

