/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class AggregateTimeoutWithExecutorServiceTest
extends ContextTestSupport {
    public static final int NUM_AGGREGATORS = 20;

    public void testThreadNotUsedForEveryAggregatorWithCustomExecutorService() throws Exception {
        int i;
        AggregateTimeoutWithExecutorServiceTest.assertTrue((String)"There should not be a thread for every aggregator when using a shared thread pool", (AggregateTimeoutWithExecutorServiceTest.aggregateThreadsCount() < 20 ? 1 : 0) != 0);
        for (i = 0; i < 20; ++i) {
            MockEndpoint result = this.getMockEndpoint("mock:result" + i);
            result.expectedBodiesReceived(new Object[]{"Message 4"});
        }
        for (i = 0; i < 20; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.template.sendBodyAndHeader("direct:start" + i, (Object)("Message " + j), "id", (Object)"1");
            }
        }
        this.assertMockEndpointsSatisfied();
    }

    public static int aggregateThreadsCount() {
        int count = 0;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || !thread.getName().contains("AggregateTimeoutChecker")) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ScheduledExecutorService threadPool = AggregateTimeoutWithExecutorServiceTest.this.context.getExecutorServiceManager().newScheduledThreadPool((Object)this, "MyThreadPool", 8);
                for (int i = 0; i < 20; ++i) {
                    this.from("direct:start" + i).aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(3000L).timeoutCheckerExecutorService(threadPool).to("mock:result" + i);
                }
            }
        };
    }
}

