/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class AggregationStrategyAsPredicateTest
extends ContextTestSupport {
    public void testAggregateCompletionAware() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:aggregated");
        result.expectedBodiesReceived(new Object[]{"A+B+C", "X+Y+ZZZZ"});
        ((ValueBuilder)result.message(0).exchangeProperty("CamelAggregatedCompletedBy")).isEqualTo((Object)"predicate");
        ((ValueBuilder)result.message(1).exchangeProperty("CamelAggregatedCompletedBy")).isEqualTo((Object)"predicate");
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"X", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"Y", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"ZZZZ", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyCompletionStrategy()).to("mock:aggregated");
            }
        };
    }

    private final class MyCompletionStrategy
    implements AggregationStrategy,
    Predicate {
        private MyCompletionStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class) + "+" + (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)body);
            return oldExchange;
        }

        public boolean matches(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            return body.length() >= 5;
        }
    }
}

