/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.processor.aggregator.AbstractDistributedTest;
import org.apache.camel.spi.AggregationRepository;

public class DistributedCompletionIntervalTest
extends AbstractDistributedTest {
    private MemoryAggregationRepository sharedAggregationRepository = new MemoryAggregationRepository(true);

    public void testCamelContext1Wins() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Message 19"});
        MockEndpoint mock2 = this.getMockEndpoint2("mock:result");
        mock2.expectedMessageCount(0);
        Thread.sleep(2000L);
        this.sendMessages();
        mock.assertIsSatisfied();
        mock2.assertIsSatisfied();
    }

    public void testCamelContext2Wins() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        MockEndpoint mock2 = this.getMockEndpoint2("mock:result");
        mock2.expectedBodiesReceived(new Object[]{"Message 19"});
        Thread.sleep(2000L);
        this.sendMessages();
        mock2.assertIsSatisfied();
        mock.assertIsSatisfied();
    }

    private void sendMessages() {
        for (int i = 0; i < 20; ++i) {
            int choice = i % 2;
            if (choice == 0) {
                this.template.sendBodyAndHeader("direct:start", (Object)("Message " + i), "id", (Object)"1");
                continue;
            }
            this.template2.sendBodyAndHeader("direct:start", (Object)("Message " + i), "id", (Object)"1");
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).aggregationRepository((AggregationRepository)DistributedCompletionIntervalTest.this.sharedAggregationRepository).optimisticLocking().completionInterval(DistributedCompletionIntervalTest.this.getName().equals("testCamelContext1Wins") ? 5000L : 10000L).to("mock:result");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilder2() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).aggregationRepository((AggregationRepository)DistributedCompletionIntervalTest.this.sharedAggregationRepository).optimisticLocking().completionInterval(DistributedCompletionIntervalTest.this.getName().equals("testCamelContext1Wins") ? 10000L : 5000L).to("mock:result");
            }
        };
    }
}

