/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ThreadsDefinition;

public class AsyncDefaultErrorHandlerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testAsyncDefaultErrorHandlerWait() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:in").threads(2).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new Exception("Forced exception by unit test");
                    }
                });
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        try {
            this.template.requestBody("direct:in", (Object)"Hello World");
            AsyncDefaultErrorHandlerTest.fail((String)"Should have thrown a CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            AsyncDefaultErrorHandlerTest.assertEquals((String)"Forced exception by unit test", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }
}

