/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class AsyncEndpointEventNotifierSendingTest
extends ContextTestSupport {
    private final List<EventObject> events = new ArrayList<EventObject>();

    public void testAsyncEndpointEventNotifier() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointEventNotifierSendingTest.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointEventNotifierSendingTest.assertEquals((int)8, (int)this.events.size());
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(0));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(1));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(2));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(3));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(4));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(5));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(6));
        AsyncEndpointEventNotifierSendingTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(7));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                AsyncEndpointEventNotifierSendingTest.this.events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return event instanceof ExchangeSendingEvent || event instanceof ExchangeSentEvent;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointEventNotifierSendingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("async:bye:camel?delay=250")).to("mock:result");
            }
        };
    }
}

