/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import junit.framework.TestCase;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutingSlip;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointRoutingSlipBean3Test
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyRoutingSlipBean());
        return jndi;
    }

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointRoutingSlipBean3Test.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointRoutingSlipBean3Test.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointRoutingSlipBean3Test.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).beanRef("myBean");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                        String body = (String)exchange.getIn().getBody(String.class);
                        TestCase.assertEquals((String)"Hi World", (String)body);
                        exchange.getOut().setBody((Object)"Bye Camel");
                    }
                })).to("log:after")).to("mock:after")).to("mock:result");
            }
        };
    }

    public static class MyRoutingSlipBean {
        @RoutingSlip
        public String doSomething() {
            return "async:hi:world,direct:foo";
        }
    }
}

