/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutingSlip;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointRoutingSlipBeanTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyRoutingSlipBean());
        return jndi;
    }

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointRoutingSlipBeanTest.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointRoutingSlipBeanTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.from("direct:start").beanRef("myBean");
            }
        };
    }

    public static class MyRoutingSlipBean {
        @RoutingSlip
        public String doSomething() {
            return "async:bye:camel,mock:result";
        }
    }
}

