/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointSplitFineGrainedErrorHandlingTest
extends ContextTestSupport {
    private static int counter;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel", "Bye Camel", "Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C"});
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
        AsyncEndpointSplitFineGrainedErrorHandlingTest.assertEquals((int)4, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointSplitFineGrainedErrorHandlingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.onException(Exception.class).maximumRedeliveries(2).redeliveryDelay(0L);
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.body()).to("mock:before")).to("async:bye:camel")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if (counter++ == 1) {
                            throw new IllegalArgumentException("Cannot do this");
                        }
                    }
                })).to("mock:after")).end().to("mock:result");
            }
        };
    }
}

