/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class AsyncEndpointUoWTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;
    private MySynchronization sync = new MySynchronization();

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointUoWTest.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        Thread.sleep(1000L);
        AsyncEndpointUoWTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
        AsyncEndpointUoWTest.assertEquals((int)1, (int)this.sync.isOnComplete());
        AsyncEndpointUoWTest.assertEquals((int)0, (int)this.sync.isOnFailure());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointUoWTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                        exchange.addOnCompletion((Synchronization)AsyncEndpointUoWTest.this.sync);
                    }
                })).to("mock:before")).to("log:before")).to("async:bye:camel")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).to("mock:result");
            }
        };
    }

    private static class MySynchronization
    extends SynchronizationAdapter {
        private AtomicInteger onComplete = new AtomicInteger();
        private AtomicInteger onFailure = new AtomicInteger();

        private MySynchronization() {
        }

        public void onComplete(Exchange exchange) {
            this.onComplete.incrementAndGet();
        }

        public void onFailure(Exchange exchange) {
            this.onFailure.incrementAndGet();
        }

        public int isOnComplete() {
            return this.onComplete.get();
        }

        public int isOnFailure() {
            return this.onFailure.get();
        }
    }
}

