/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.RouteDefinition;

public class PollEnricherNoResourceTest
extends ContextTestSupport {
    public void testNoResourceA() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).isNull();
        this.getMockEndpoint("mock:result").expectedHeaderReceived("CamelToEndpoint", (Object)"seda://foo");
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testResourceA() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Bye World");
        Thread.sleep(250L);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("CamelToEndpoint", (Object)"seda://foo");
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testResourceB() throws Exception {
        this.template.sendBody("seda:bar", (Object)"Bye World");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("CamelToEndpoint", (Object)"seda://bar");
        this.template.sendBody("direct:b", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").pollEnrich("seda:foo", 1000L)).to("mock:result");
                ((RouteDefinition)this.from("direct:b").pollEnrich("seda:bar")).to("mock:result");
            }
        };
    }
}

