/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.camel.AlreadyStoppedException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ValidationException;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.exceptionpolicy.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;

public class DefaultExceptionPolicyStrategyTest
extends TestCase {
    private DefaultExceptionPolicyStrategy strategy;
    private HashMap<ExceptionPolicyKey, OnExceptionDefinition> policies;
    private OnExceptionDefinition type1;
    private OnExceptionDefinition type2;
    private OnExceptionDefinition type3;

    private void setupPolicies() {
        this.strategy = new DefaultExceptionPolicyStrategy();
        this.policies = new HashMap();
        this.type1 = new OnExceptionDefinition(CamelExchangeException.class);
        this.type2 = new OnExceptionDefinition(Exception.class);
        this.type3 = new OnExceptionDefinition(IOException.class);
        this.policies.put(new ExceptionPolicyKey(null, CamelExchangeException.class, null), this.type1);
        this.policies.put(new ExceptionPolicyKey(null, Exception.class, null), this.type2);
        this.policies.put(new ExceptionPolicyKey(null, IOException.class, null), this.type3);
    }

    private void setupPoliciesNoTopLevelException() {
        this.strategy = new DefaultExceptionPolicyStrategy();
        this.policies = new HashMap();
        this.type1 = new OnExceptionDefinition(CamelExchangeException.class);
        this.type3 = new OnExceptionDefinition(IOException.class);
        this.policies.put(new ExceptionPolicyKey(null, CamelExchangeException.class, null), this.type1);
        this.policies.put(new ExceptionPolicyKey(null, IOException.class, null), this.type3);
    }

    private void setupPoliciesCausedBy() {
        this.strategy = new DefaultExceptionPolicyStrategy();
        this.policies = new HashMap();
        this.type1 = new OnExceptionDefinition(FileNotFoundException.class);
        this.type2 = new OnExceptionDefinition(ConnectException.class);
        this.type3 = new OnExceptionDefinition(IOException.class);
        this.policies.put(new ExceptionPolicyKey(null, FileNotFoundException.class, null), this.type1);
        this.policies.put(new ExceptionPolicyKey(null, IOException.class, null), this.type2);
        this.policies.put(new ExceptionPolicyKey(null, ConnectException.class, null), this.type3);
    }

    public void testDirectMatch1() {
        this.setupPolicies();
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new CamelExchangeException("", null));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type1, (Object)result);
    }

    public void testDirectMatch2() {
        this.setupPolicies();
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new Exception(""));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type2, (Object)result);
    }

    public void testDirectMatch3() {
        this.setupPolicies();
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new IOException(""));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type3, (Object)result);
    }

    public void testClosetMatch3() {
        this.setupPolicies();
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new ConnectException(""));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type3, (Object)result);
        result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new SocketException(""));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type3, (Object)result);
        result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new FileNotFoundException());
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type3, (Object)result);
    }

    public void testClosetMatch2() {
        this.setupPolicies();
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new ClassCastException(""));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type2, (Object)result);
        result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new NumberFormatException(""));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type2, (Object)result);
        result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new NullPointerException());
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type2, (Object)result);
    }

    public void testClosetMatch1() {
        this.setupPolicies();
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new ValidationException(null, ""));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type1, (Object)result);
        result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new ExchangeTimedOutException(null, 0L));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type1, (Object)result);
    }

    public void testNoMatch1ThenMatchingJustException() {
        this.setupPolicies();
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new AlreadyStoppedException());
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type2, (Object)result);
    }

    public void testNoMatch1ThenNull() {
        this.setupPoliciesNoTopLevelException();
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new AlreadyStoppedException());
        DefaultExceptionPolicyStrategyTest.assertNull((String)"Should not find an exception policy to use", (Object)result);
    }

    public void testCausedBy() {
        this.setupPoliciesCausedBy();
        IOException ioe = new IOException("Damm");
        ioe.initCause(new FileNotFoundException("Somefile not found"));
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)ioe);
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type1, (Object)result);
    }

    public void testCausedByWrapped() {
        this.setupPoliciesCausedBy();
        IOException ioe = new IOException("Damm");
        ioe.initCause(new FileNotFoundException("Somefile not found"));
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)new RuntimeCamelException((Throwable)ioe));
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type1, (Object)result);
    }

    public void testCausedByNotConnected() {
        this.setupPoliciesCausedBy();
        IOException ioe = new IOException("Damm");
        ioe.initCause(new ConnectException("Not connected"));
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)ioe);
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type3, (Object)result);
    }

    public void testCausedByOtherIO() {
        this.setupPoliciesCausedBy();
        IOException ioe = new IOException("Damm");
        ioe.initCause(new MalformedURLException("Bad url"));
        OnExceptionDefinition result = this.strategy.getExceptionPolicy(this.policies, null, (Throwable)ioe);
        DefaultExceptionPolicyStrategyTest.assertEquals((Object)this.type2, (Object)result);
    }
}

