/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InterceptStrategy;

public class ParentChildInterceptStrategyTest
extends ContextTestSupport {
    protected static final List<String> LIST = new ArrayList<String>();

    public void testParentChild() throws Exception {
        this.getMockEndpoint("mock:done").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:e").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        ParentChildInterceptStrategyTest.assertEquals((int)7, (int)LIST.size());
        ParentChildInterceptStrategyTest.assertEquals((String)"Parent route -> target task-a", (String)LIST.get(0));
        ParentChildInterceptStrategyTest.assertEquals((String)"Parent when -> target task-b", (String)LIST.get(1));
        ParentChildInterceptStrategyTest.assertEquals((String)"Parent when -> target task-c", (String)LIST.get(2));
        ParentChildInterceptStrategyTest.assertEquals((String)"Parent when2 -> target task-d", (String)LIST.get(3));
        ParentChildInterceptStrategyTest.assertEquals((String)"Parent otherwise -> target task-e", (String)LIST.get(4));
        ParentChildInterceptStrategyTest.assertEquals((String)"Parent route -> target choice", (String)LIST.get(5));
        ParentChildInterceptStrategyTest.assertEquals((String)"Parent route -> target mock:done", (String)LIST.get(6));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ParentChildInterceptStrategyTest.this.context.addInterceptStrategy((InterceptStrategy)new MyParentChildInterceptStrategy());
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("route").to("mock:a")).id("task-a")).choice().id("choice")).when((Predicate)this.simple("${body} contains 'Camel'")).id("when")).to("mock:b")).id("task-b")).to("mock:c")).id("task-c")).when((Predicate)this.simple("${body} contains 'Donkey'")).id("when2")).to("mock:d")).id("task-d")).otherwise().id("otherwise")).to("mock:e")).id("task-e")).end().to("mock:done");
            }
        };
    }

    public static final class MyParentChildInterceptStrategy
    implements InterceptStrategy {
        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
            String targetId = definition.hasCustomIdAssigned() ? definition.getId() : definition.getLabel();
            ProcessorDefinition parent = definition.getParent();
            String parentId = "";
            if (parent != null) {
                parentId = parent.hasCustomIdAssigned() ? parent.getId() : parent.getLabel();
            }
            LIST.add("Parent " + parentId + " -> target " + targetId);
            return target;
        }
    }
}

