/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithMockEndpointsTest
extends ContextTestSupport {
    public void testNoAdvised() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAdvisedMockEndpoints() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.mockEndpoints();
            }
        });
        this.getMockEndpoint("mock:direct:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:direct:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:log:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("direct:foo"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("log:foo"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("mock:direct:start"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("mock:direct:foo"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
    }

    public void testAdvisedMockEndpointsWithPattern() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.mockEndpoints(new String[]{"log*"});
            }
        });
        this.getMockEndpoint("mock:log:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("direct:foo"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("log:foo"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        AdviceWithMockEndpointsTest.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
        AdviceWithMockEndpointsTest.assertNull((Object)this.context.hasEndpoint("mock:direct:start"));
        AdviceWithMockEndpointsTest.assertNull((Object)this.context.hasEndpoint("mock:direct:foo"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("direct:foo")).to("log:foo")).to("mock:result");
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

