/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithTest
extends ContextTestSupport {
    public void testNoAdvised() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAdvised() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAdvisedNoNewRoutesAllowed() throws Exception {
        try {
            ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:bar").to("mock:bar");
                    ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
                }
            });
            AdviceWithTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAdvisedThrowException() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").to("mock:advised")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            AdviceWithTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            AdviceWithTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            AdviceWithTest.assertEquals((String)"Damn", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        };
    }
}

