/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.TraceEventMessage;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class TraceFormatterTest
extends ContextTestSupport {
    private List<String> tracedBodies = new ArrayList<String>();

    public void testSendingSomeMessagesBeingTraced() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Bye World"});
        MockEndpoint mock = this.getMockEndpoint("mock:traced");
        mock.expectedMessageCount(4);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello London", "to", (Object)"James");
        this.assertMockEndpointsSatisfied();
        TraceFormatterTest.assertEquals((String)"Hello London", (String)this.tracedBodies.get(0));
        TraceFormatterTest.assertEquals((String)"Hello World", (String)this.tracedBodies.get(1));
        TraceFormatterTest.assertEquals((String)"Goodday World", (String)this.tracedBodies.get(2));
        TraceFormatterTest.assertEquals((String)"Bye World", (String)this.tracedBodies.get(3));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                MyTraceFormatter formatter = new MyTraceFormatter();
                tracer.setFormatter((TraceFormatter)formatter);
                this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
                tracer.setDestinationUri("direct:traced");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor("Hello World"))).process((Processor)new MyProcessor("Goodday World"))).process((Processor)new MyProcessor("Bye World"))).to("mock:result");
                ((RouteDefinition)this.from("direct:traced").process((Processor)new MyTraveAssertProcessor())).to("mock:traced");
            }
        };
    }

    class MyTraceFormatter
    implements TraceFormatter {
        MyTraceFormatter() {
        }

        public Object format(TraceInterceptor interceptor, ProcessorDefinition<?> node, Exchange exchange) {
            return "***" + (String)exchange.getIn().getBody(String.class) + "***";
        }
    }

    class MyTraveAssertProcessor
    implements Processor {
        MyTraveAssertProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            TraceEventMessage event = (TraceEventMessage)exchange.getIn().getBody(DefaultTraceEventMessage.class);
            TraceFormatterTest.this.tracedBodies.add(new String(event.getBody()));
        }
    }

    class MyProcessor
    implements Processor {
        private String msg;

        MyProcessor(String msg) {
            this.msg = msg;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getIn().setBody((Object)this.msg);
        }
    }
}

