/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.LinkedList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceEventHandler;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceHandlerTestHandler;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.TraceInterceptorFactory;
import org.apache.camel.processor.interceptor.TraceTestProcessor;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.processor.interceptor.TracingTestBase;

public class TraceInterceptorFactoryCreatesHandlerTest
extends TracingTestBase {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext contextLocal = super.createCamelContext();
        this.tracedMessages = new LinkedList();
        Tracer tracer = (Tracer)contextLocal.getDefaultTracer();
        tracer.setEnabled(true);
        tracer.setTraceExceptions(true);
        if ("testTracerExceptionInOut".equals(this.getName())) {
            tracer.setTraceInterceptorFactory((TraceInterceptorFactory)new TraceInterceptorFactoryCreatesHandlerTestFactory(this.tracedMessages, true));
        } else {
            tracer.setTraceInterceptorFactory((TraceInterceptorFactory)new TraceInterceptorFactoryCreatesHandlerTestFactory(this.tracedMessages, false));
        }
        return contextLocal;
    }

    private static class TraceInterceptorFactoryCreatesHandlerTestFactory
    implements TraceInterceptorFactory {
        private List<StringBuilder> eventMessages;
        private boolean traceAllNodes;

        TraceInterceptorFactoryCreatesHandlerTestFactory(List<StringBuilder> eventMessages, boolean traceAllNodes) {
            this.eventMessages = eventMessages;
            this.traceAllNodes = traceAllNodes;
        }

        public Processor createTraceInterceptor(ProcessorDefinition<?> node, Processor target, TraceFormatter formatter, Tracer tracer) {
            TraceInterceptor interceptor = new TraceInterceptor(node, target, formatter, tracer);
            while (target instanceof DelegateProcessor) {
                target = ((DelegateProcessor)target).getProcessor();
            }
            if (this.traceAllNodes || !target.getClass().equals(TraceTestProcessor.class)) {
                TraceHandlerTestHandler traceHandler = new TraceHandlerTestHandler(this.eventMessages);
                traceHandler.setTraceAllNodes(true);
                interceptor.setTraceHandler((TraceEventHandler)traceHandler);
            }
            return interceptor;
        }
    }
}

