/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.RouteDefinition;

public class ContextScopedOnExceptionLoadBalancerStopRouteTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:exception").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testError() throws Exception {
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:exception").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
    }

    public void testErrorOk() throws Exception {
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Kaboom", "World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:exception").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testErrorOkError() throws Exception {
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Kaboom", "World", "Kaboom"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:exception").expectedBodiesReceived(new Object[]{"Kaboom", "Kaboom"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.template.sendBody("direct:start", (Object)"World");
        Thread.sleep(1000L);
        ContextScopedOnExceptionLoadBalancerStopRouteTest.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteStatus("errorRoute"));
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
        SedaEndpoint seda = this.getMandatoryEndpoint("seda:error", SedaEndpoint.class);
        SedaEndpoint seda2 = this.getMandatoryEndpoint("seda:error2", SedaEndpoint.class);
        int size = seda.getQueue().size();
        int size2 = seda2.getQueue().size();
        ContextScopedOnExceptionLoadBalancerStopRouteTest.assertTrue((String)"There should be 1 exchange on the seda or seda2 queue", (size == 1 || size2 == 1 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)this.onException(Exception.class).handled(true).loadBalance().roundRobin().to(new String[]{"seda:error", "seda:error2"})).end().to("mock:exception");
                ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).choice().when(this.body().contains((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Forced"))).otherwise().transform((Expression)this.body().prepend((Object)"Bye "))).to("mock:result");
                ((RouteDefinition)this.from("seda:error").routeId("errorRoute").to("controlbus:route?action=stop&routeId=errorRoute&async=true")).to("mock:error");
            }
        };
    }
}

