/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class ContextScopedOnExceptionLogRouteTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testContextScopedOnExceptionLogRouteBarFail() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).log("Error due ${exception.message}");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("mock:foo")).to("direct:bar")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("mock:bar")).throwException((Exception)new IllegalArgumentException("Forced bar error"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ContextScopedOnExceptionLogRouteTest.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testContextScopedOnExceptionLogRouteFooFail() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).log("Error due ${exception.message}");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Forced foo error"))).to("direct:bar")).to("mock:result");
                this.from("direct:bar").routeId("bar").to("mock:bar");
                this.from("direct:killer").routeId("killer").to("mock:killer");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ContextScopedOnExceptionLogRouteTest.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }
}

