/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import org.apache.camel.processor.resequencer.ResequencerEngineSync;

public class ResequencerRunner<E>
extends Thread {
    private ResequencerEngineSync<E> resequencer;
    private long interval;
    private boolean cancelRequested;

    public ResequencerRunner(ResequencerEngineSync<E> resequencer, long interval) {
        this.resequencer = resequencer;
        this.interval = interval;
        this.cancelRequested = false;
    }

    @Override
    public void run() {
        while (!this.cancelRequested()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                this.resequencer.deliver();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.run();
    }

    public synchronized void cancel() {
        this.cancelRequested = true;
    }

    private synchronized boolean cancelRequested() {
        return this.cancelRequested;
    }
}

