/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import javax.naming.Context;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.jndi.JndiContext;

public class RoutingSlipDataModificationTest
extends ContextTestSupport {
    protected static final String ANSWER = "answer";
    protected static final String ROUTING_SLIP_HEADER = "routingSlipHeader";
    protected MyBean myBean = new MyBean();

    public void testModificationOfDataAlongRoute() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        x.expectedBodiesReceived(new Object[]{ANSWER});
        y.expectedBodiesReceived(new Object[]{"answeranswer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
    }

    protected void sendBody() {
        this.template.sendBodyAndHeader("direct:a", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:x , bean:myBean?method=modifyData");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object lookedUpBean = this.context.getRegistry().lookupByName("myBean");
        RoutingSlipDataModificationTest.assertSame((String)"Lookup of 'myBean' should return same object!", (Object)this.myBean, (Object)lookedUpBean);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").routingSlip((Expression)this.header(RoutingSlipDataModificationTest.ROUTING_SLIP_HEADER)).to("mock:y");
            }
        };
    }

    public static class MyBean {
        public String modifyData(@Body String body) {
            return body + body;
        }
    }
}

