/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import junit.framework.TestCase;
import org.apache.camel.support.DefaultTimeoutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTimeoutMapTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTimeoutMapTest.class);
    private ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1);

    public void testDefaultTimeoutMap() throws Exception {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor);
        map.start();
        DefaultTimeoutMapTest.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.stop();
    }

    public void testDefaultTimeoutMapPurge() throws Exception {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.start();
        DefaultTimeoutMapTest.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)123, 50L);
        DefaultTimeoutMapTest.assertEquals((int)1, (int)map.size());
        Thread.sleep(250L);
        if (map.size() > 0) {
            LOG.warn("Waiting extra due slow CI box");
            Thread.sleep(1000L);
        }
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.stop();
    }

    public void testDefaultTimeoutMapForcePurge() throws Exception {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.start();
        DefaultTimeoutMapTest.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)123, 50L);
        DefaultTimeoutMapTest.assertEquals((int)1, (int)map.size());
        Thread.sleep(250L);
        map.purge();
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
    }

    public void testDefaultTimeoutMapGetRemove() throws Exception {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.start();
        DefaultTimeoutMapTest.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)123, 50L);
        DefaultTimeoutMapTest.assertEquals((int)1, (int)map.size());
        DefaultTimeoutMapTest.assertEquals((int)123, (int)((Integer)map.get((Object)"A")));
        Object old = map.remove((Object)"A");
        DefaultTimeoutMapTest.assertEquals((Object)123, (Object)old);
        DefaultTimeoutMapTest.assertEquals(null, (Object)map.get((Object)"A"));
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.stop();
    }

    public void testDefaultTimeoutMapGetKeys() throws Exception {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.start();
        DefaultTimeoutMapTest.assertTrue((map.currentTime() > 0L ? 1 : 0) != 0);
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)123, 50L);
        map.put((Object)"B", (Object)456, 50L);
        DefaultTimeoutMapTest.assertEquals((int)2, (int)map.size());
        Object[] keys = map.getKeys();
        DefaultTimeoutMapTest.assertNotNull((Object)keys);
        DefaultTimeoutMapTest.assertEquals((int)2, (int)keys.length);
    }

    public void testExecutor() throws Exception {
        ScheduledExecutorService e = Executors.newScheduledThreadPool(2);
        DefaultTimeoutMap map = new DefaultTimeoutMap(e, 50L);
        map.start();
        DefaultTimeoutMapTest.assertEquals((long)50L, (long)map.getPurgePollTime());
        map.put((Object)"A", (Object)123, 100L);
        DefaultTimeoutMapTest.assertEquals((int)1, (int)map.size());
        Thread.sleep(250L);
        if (map.size() > 0) {
            LOG.warn("Waiting extra due slow CI box");
            Thread.sleep(1000L);
        }
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        DefaultTimeoutMapTest.assertSame((Object)e, (Object)map.getExecutor());
        map.stop();
    }

    public void testExpiredInCorrectOrder() throws Exception {
        final ArrayList keys = new ArrayList();
        final ArrayList values = new ArrayList();
        DefaultTimeoutMap<String, Integer> map = new DefaultTimeoutMap<String, Integer>(this.executor, 100L){

            public boolean onEviction(String key, Integer value) {
                keys.add(key);
                values.add(value);
                return true;
            }
        };
        map.start();
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)1, 50L);
        map.put((Object)"B", (Object)2, 30L);
        map.put((Object)"C", (Object)3, 40L);
        map.put((Object)"D", (Object)4, 20L);
        map.put((Object)"E", (Object)5, 40L);
        map.put((Object)"F", (Object)6, 800L);
        Thread.sleep(250L);
        map.purge();
        DefaultTimeoutMapTest.assertEquals((String)"D", (String)((String)keys.get(0)));
        DefaultTimeoutMapTest.assertEquals((int)4, (int)((Integer)values.get(0)));
        DefaultTimeoutMapTest.assertEquals((String)"B", (String)((String)keys.get(1)));
        DefaultTimeoutMapTest.assertEquals((int)2, (int)((Integer)values.get(1)));
        DefaultTimeoutMapTest.assertEquals((String)"C", (String)((String)keys.get(2)));
        DefaultTimeoutMapTest.assertEquals((int)3, (int)((Integer)values.get(2)));
        DefaultTimeoutMapTest.assertEquals((String)"E", (String)((String)keys.get(3)));
        DefaultTimeoutMapTest.assertEquals((int)5, (int)((Integer)values.get(3)));
        DefaultTimeoutMapTest.assertEquals((String)"A", (String)((String)keys.get(4)));
        DefaultTimeoutMapTest.assertEquals((int)1, (int)((Integer)values.get(4)));
        DefaultTimeoutMapTest.assertEquals((int)1, (int)map.size());
        map.stop();
    }

    public void testExpiredNotEvicted() throws Exception {
        final ArrayList keys = new ArrayList();
        final ArrayList values = new ArrayList();
        DefaultTimeoutMap<String, Integer> map = new DefaultTimeoutMap<String, Integer>(this.executor, 100L){

            public boolean onEviction(String key, Integer value) {
                if ("gold".equals(key)) {
                    return false;
                }
                keys.add(key);
                values.add(value);
                return true;
            }
        };
        map.start();
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)1, 90L);
        map.put((Object)"B", (Object)2, 100L);
        map.put((Object)"gold", (Object)9, 110L);
        map.put((Object)"C", (Object)3, 120L);
        Thread.sleep(250L);
        map.purge();
        DefaultTimeoutMapTest.assertEquals((String)"A", (String)((String)keys.get(0)));
        DefaultTimeoutMapTest.assertEquals((int)1, (int)((Integer)values.get(0)));
        DefaultTimeoutMapTest.assertEquals((String)"B", (String)((String)keys.get(1)));
        DefaultTimeoutMapTest.assertEquals((int)2, (int)((Integer)values.get(1)));
        DefaultTimeoutMapTest.assertEquals((String)"C", (String)((String)keys.get(2)));
        DefaultTimeoutMapTest.assertEquals((int)3, (int)((Integer)values.get(2)));
        DefaultTimeoutMapTest.assertEquals((int)1, (int)map.size());
        DefaultTimeoutMapTest.assertEquals((Object)9, (Object)map.get((Object)"gold"));
        map.stop();
    }

    public void testDefaultTimeoutMapStopStart() throws Exception {
        DefaultTimeoutMap map = new DefaultTimeoutMap(this.executor, 100L);
        map.start();
        map.put((Object)"A", (Object)1, 500L);
        DefaultTimeoutMapTest.assertEquals((int)1, (int)map.size());
        map.stop();
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.put((Object)"A", (Object)1, 50L);
        Thread.sleep(250L);
        DefaultTimeoutMapTest.assertEquals((int)1, (int)map.size());
        map.start();
        Thread.sleep(250L);
        if (map.size() > 0) {
            LOG.warn("Waiting extra due slow CI box");
            Thread.sleep(1000L);
        }
        DefaultTimeoutMapTest.assertEquals((int)0, (int)map.size());
        map.stop();
    }
}

