/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.TestSupport;
import org.apache.camel.support.ServiceSupport;

public class ServiceSupportTest
extends TestSupport {
    public void testServiceSupport() throws Exception {
        MyService service = new MyService();
        service.start();
        ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isStarted());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStarting());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStopped());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStopping());
        service.stop();
        ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isStopped());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStopping());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStarted());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStarting());
    }

    public void testServiceSupportIsRunAllowed() throws Exception {
        MyService service = new MyService();
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isRunAllowed());
        service.start();
        ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isRunAllowed());
        service.suspend();
        ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isRunAllowed());
        service.resume();
        ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isRunAllowed());
        service.stop();
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isRunAllowed());
        service.shutdown();
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isRunAllowed());
    }

    public void testServiceSupportShutdown() throws Exception {
        MyShutdownService service = new MyShutdownService();
        service.start();
        ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isStarted());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStarting());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStopped());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStopping());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isShutdown());
        service.shutdown();
        ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isStopped());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStopping());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStarted());
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStarting());
        ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isShutdown());
    }

    public void testExceptionOnStart() throws Exception {
        ServiceSupportTestExOnStart service = new ServiceSupportTestExOnStart();
        ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStopped());
        try {
            service.start();
            ServiceSupportTest.fail((String)"RuntimeException expected");
        }
        catch (RuntimeException e) {
            ServiceSupportTest.assertEquals((boolean)true, (boolean)service.isStopped());
            ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStopping());
            ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStarted());
            ServiceSupportTest.assertEquals((boolean)false, (boolean)service.isStarting());
        }
    }

    public static class ServiceSupportTestExOnStart
    extends ServiceSupport {
        public ServiceSupportTestExOnStart() {
            this.stopped.set(false);
        }

        protected void doStart() throws Exception {
            throw new RuntimeException("This service throws an exception when starting");
        }

        protected void doStop() throws Exception {
        }
    }

    private static class MyShutdownService
    extends ServiceSupport {
        private boolean shutdown;

        private MyShutdownService() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }

        protected void doShutdown() throws Exception {
            this.shutdown = true;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }
    }

    private static class MyService
    extends ServiceSupport {
        private MyService() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

