/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.util.component.ApiMethodParser;
import org.apache.camel.util.component.ArgumentSubstitutionParser;
import org.apache.camel.util.component.TestProxy;
import org.junit.Assert;
import org.junit.Test;

public class ArgumentSubstitutionParserTest {
    private static final String PERSON = "person";

    @Test
    public void testParse() throws Exception {
        ArgumentSubstitutionParser.Substitution[] adapters = new ArgumentSubstitutionParser.Substitution[]{new ArgumentSubstitutionParser.Substitution(".+", "name", PERSON), new ArgumentSubstitutionParser.Substitution("greet.+", "person([0-9]+)", "astronaut$1"), new ArgumentSubstitutionParser.Substitution(".+", "(.+)", "java.util.List", "$1List"), new ArgumentSubstitutionParser.Substitution(".+", "(.+)", ".*?(\\w++)\\[\\]", "$1Array", true)};
        ArgumentSubstitutionParser parser = new ArgumentSubstitutionParser(TestProxy.class, adapters);
        ArrayList<String> signatures = new ArrayList<String>();
        signatures.add("public String sayHi();");
        signatures.add("public String sayHi(final String name);");
        signatures.add("public final String greetMe(final String name);");
        signatures.add("public final String greetUs(final String name1, String name2);");
        signatures.add("public final String greetAll(String[] names);");
        signatures.add("public final String greetAll(java.util.List<String> names);");
        signatures.add("public final java.util.Map<String, String> greetAll(java.util.Map<String> nameMap);");
        signatures.add("public final String[] greetTimes(String name, int times);");
        parser.setSignatures(signatures);
        List methodModels = parser.parse();
        Assert.assertEquals((long)8L, (long)methodModels.size());
        ApiMethodParser.ApiMethodModel sayHi1 = (ApiMethodParser.ApiMethodModel)methodModels.get(7);
        Assert.assertEquals((Object)PERSON, (Object)((ApiMethodParser.Argument)sayHi1.getArguments().get(0)).getName());
        Assert.assertEquals((Object)"SAYHI_1", (Object)sayHi1.getUniqueName());
        ApiMethodParser.ApiMethodModel greetMe = (ApiMethodParser.ApiMethodModel)methodModels.get(3);
        Assert.assertEquals((Object)PERSON, (Object)((ApiMethodParser.Argument)greetMe.getArguments().get(0)).getName());
        ApiMethodParser.ApiMethodModel greetUs = (ApiMethodParser.ApiMethodModel)methodModels.get(5);
        Assert.assertEquals((Object)"astronaut1", (Object)((ApiMethodParser.Argument)greetUs.getArguments().get(0)).getName());
        Assert.assertEquals((Object)"astronaut2", (Object)((ApiMethodParser.Argument)greetUs.getArguments().get(1)).getName());
        ApiMethodParser.ApiMethodModel greetAll = (ApiMethodParser.ApiMethodModel)methodModels.get(0);
        Assert.assertEquals((Object)"personMap", (Object)((ApiMethodParser.Argument)greetAll.getArguments().get(0)).getName());
        ApiMethodParser.ApiMethodModel greetAll1 = (ApiMethodParser.ApiMethodModel)methodModels.get(1);
        Assert.assertEquals((Object)"personsList", (Object)((ApiMethodParser.Argument)greetAll1.getArguments().get(0)).getName());
        ApiMethodParser.ApiMethodModel greetAll2 = (ApiMethodParser.ApiMethodModel)methodModels.get(2);
        Assert.assertEquals((Object)"stringArray", (Object)((ApiMethodParser.Argument)greetAll2.getArguments().get(0)).getName());
    }
}

