/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;

public class SizedScheduledExecutorServiceTest
extends TestCase {
    public void testSizedScheduledExecutorService() throws Exception {
        ScheduledThreadPoolExecutor delegate = new ScheduledThreadPoolExecutor(5);
        SizedScheduledExecutorService sized = new SizedScheduledExecutorService(delegate, 2L);
        Runnable task = new Runnable(){

            @Override
            public void run() {
            }
        };
        sized.schedule(task, 2L, TimeUnit.SECONDS);
        sized.schedule(task, 3L, TimeUnit.SECONDS);
        try {
            sized.schedule(task, 4L, TimeUnit.SECONDS);
            SizedScheduledExecutorServiceTest.fail((String)"Should have thrown exception");
        }
        catch (RejectedExecutionException e) {
            SizedScheduledExecutorServiceTest.assertEquals((String)"Task rejected due queue size limit reached", (String)e.getMessage());
        }
        sized.shutdownNow();
        SizedScheduledExecutorServiceTest.assertTrue((String)"Should be shutdown", (sized.isShutdown() || sized.isTerminating() ? 1 : 0) != 0);
        SizedScheduledExecutorServiceTest.assertTrue((String)"Should be shutdown", (delegate.isShutdown() || sized.isTerminating() ? 1 : 0) != 0);
    }
}

