/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchProviderException;
import org.apache.camel.CamelContext;
import org.apache.camel.util.jsse.AbstractJsseParametersTest;
import org.apache.camel.util.jsse.KeyStoreParameters;

public class KeyStoreParametersTest
extends AbstractJsseParametersTest {
    protected KeyStoreParameters createMinimalKeyStoreParameters() {
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource("org/apache/camel/util/jsse/localhost.ks");
        ksp.setPassword("changeit");
        return ksp;
    }

    public void testPropertyPlaceholders() throws Exception {
        CamelContext context = this.createPropertiesPlaceholderAwareContext();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setCamelContext(context);
        ksp.setType("{{keyStoreParameters.type}}");
        ksp.setProvider("{{keyStoreParameters.provider}}");
        ksp.setResource("{{keyStoreParameters.resource}}");
        ksp.setPassword("{{keyStoreParamerers.password}}");
        KeyStore ks = ksp.createKeyStore();
        KeyStoreParametersTest.assertNotNull((Object)ks.getCertificate("server"));
    }

    public void testValidParameters() throws GeneralSecurityException, IOException, URISyntaxException {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        KeyStore ks = ksp.createKeyStore();
        KeyStoreParametersTest.assertNotNull((Object)ks.getCertificate("server"));
        URL resourceUrl = ((Object)((Object)this)).getClass().getResource("/org/apache/camel/util/jsse/localhost.ks");
        ksp.setResource(resourceUrl.toExternalForm());
        ks = ksp.createKeyStore();
        KeyStoreParametersTest.assertNotNull((Object)ks.getCertificate("server"));
        resourceUrl = ((Object)((Object)this)).getClass().getResource("/org/apache/camel/util/jsse/localhost.ks");
        File file = new File(resourceUrl.toURI());
        ksp.setResource(file.getAbsolutePath());
        ks = ksp.createKeyStore();
        KeyStoreParametersTest.assertNotNull((Object)ks.getCertificate("server"));
    }

    public void testExplicitType() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setType("jks");
        KeyStore ks = ksp.createKeyStore();
        KeyStoreParametersTest.assertNotNull((Object)ks.getCertificate("server"));
    }

    public void testExplicitProvider() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setProvider(ksp.createKeyStore().getProvider().getName());
        KeyStore ks = ksp.createKeyStore();
        KeyStoreParametersTest.assertNotNull((Object)ks.getCertificate("server"));
    }

    public void testExplicitInvalidProvider() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setProvider("sdfdsfgfdsgdsfg");
        try {
            ksp.createKeyStore();
            KeyStoreParametersTest.fail();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
    }

    public void testExplicitInvalidType() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setType("pkcs12");
        try {
            ksp.createKeyStore();
            KeyStoreParametersTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testIncorrectPassword() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setPassword("");
        try {
            ksp.createKeyStore();
            KeyStoreParametersTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testIncorrectResource() throws Exception {
        KeyStoreParameters ksp = this.createMinimalKeyStoreParameters();
        ksp.setResource("");
        try {
            ksp.createKeyStore();
            KeyStoreParametersTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

